---
generated_at: 2026-02-03 10:30:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：157-Cat リカバリ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - 特になし

## 2) 参照した情報（Evidence一覧）

- E-01: `rest-api-spec/src/main/resources/rest-api-spec/api/cat.recovery.json`
- E-02: `server/src/main/java/org/opensearch/rest/action/cat/RestCatRecoveryAction.java`
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` 行158

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | APIエンドポイントは GET /_cat/recovery と GET /_cat/recovery/{index} | E-01, E-02 行72 | ○ |
| C-02 | リクエストパラメータにactive_only, bytes, detailed等が存在 | E-01, E-02 行88-92 | ○ |
| C-03 | 表示カラムは26カラム | E-02 行103-134 | ○ |
| C-04 | シャードIDでソートされる | E-02 行156-169 introSort | ○ |
| C-05 | ソースノードがnullの場合"n/a"表示 | E-02 行182-183 | ○ |
| C-06 | スナップショットリカバリ以外はrepository/snapshotが"n/a" | E-02 行186-195 | ○ |
| C-07 | 進捗率は"X.X%"形式で表示 | E-02 行198, 202, 206 format "%1.1f%%" | ○ |
| C-08 | RecoveryRequestをインデックス管理APIに発行 | E-02 行88, 94 | ○ |
| C-09 | active_onlyパラメータでフィルタリング | E-02 行91 | ○ |
| C-10 | detailedパラメータサポート | E-02 行90 | ○ |
| C-11 | IndicesOptionsサポート | E-02 行92 | ○ |
| C-12 | 時刻はDEFAULT_FORMATTERでフォーマット | E-02 行175, 177 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードとAPI仕様から直接確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] 表示カラムの一覧がソースコードのgetTableWithHeader()と一致しているか
- [ ] リカバリタイプの列挙が正確か
- [ ] リクエストパラメータがcat.recovery.jsonの定義と一致しているか
